<?php
require_once(__DIR__ . '/crest.php');
require_once(__DIR__ . '/surepassApis.php');


try {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
        ob_start();

        if ($_POST['action'] === 'getApiData') {
            updateDealWithRcData($_POST['dealId'], $_POST['response']);
        } elseif ($_POST['action'] === 'getDealData') {
            updateDealWithDealData($_POST['dealId'], $_POST['response']);
        }

        $output = ob_get_clean();
        echo $output;
        exit;
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}

function updateDealWithDealData($dealId, $response) {
    try {
        $response = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception("Error decoding response: " . json_last_error_msg());
        }

        $updateData = [
            'ID' => $dealId,
            'fields' => [
                'UF_CRM_657A8556EA17C' => $response['UF_CRM_657A8556EA17C'],
                'UF_CRM_1722269383' => $response['UF_CRM_1722269383'],
                'UF_CRM_1689412695' => $response['UF_CRM_1689412695'],
                'UF_CRM_1707034449' => $response['UF_CRM_1707034449'],
                'UF_CRM_1722269439' => $response['UF_CRM_1722269439'],
                'UF_CRM_1722757025397' => $response['UF_CRM_1722757025397'],
                'UF_CRM_1722763762758' => $response['UF_CRM_1722763762758'],
                'UF_CRM_1722269536' => $response['UF_CRM_1722269536'],
                'UF_CRM_1721409291383' => $response['UF_CRM_1721409291383'],
                'UF_CRM_1721409255084' => $response['UF_CRM_1721409255084'],
                'UF_CRM_6503E06165ABF' => $response['UF_CRM_6503E06165ABF'],
                'UF_CRM_1722269585' => $response['UF_CRM_1722269585'],
                'UF_CRM_1722927145947' => $response['UF_CRM_1722927145947'],
                'UF_CRM_1722269718' => $response['UF_CRM_1722269718'],
                'UF_CRM_1721409885267' => $response['UF_CRM_1721409885267'],
                'UF_CRM_1722862270631' => $response['UF_CRM_1722862270631'],
                'UF_CRM_1693205894' => $response['UF_CRM_1693205894'],
                'UF_CRM_64E72F2857676' => $response['UF_CRM_64E72F2857676'],
                'UF_CRM_1722269775' => $response['UF_CRM_1722269775'],
                'UF_CRM_1722269847' => $response['UF_CRM_1722269847'],
                'UF_CRM_1689414361007' => $response['UF_CRM_1689414361007'],
                'UF_CRM_1722270007' => $response['UF_CRM_1722270007'],
                'UF_CRM_1722270049' => $response['UF_CRM_1722270049'],
                'UF_CRM_1722270087' => $response['UF_CRM_1722270087'],
                'UF_CRM_1722270133' => $response['UF_CRM_1722270133'],
            ],
        ];

        $updateResult = CRest::call('crm.deal.update', $updateData);

        if (isset($updateResult['error'])) {
            throw new Exception("Error updating deal: " . $updateResult['error_description']);
        }

        if ($updateResult['result'] == 1) {
            echo "Deal updated successfully...";
        } else {
            echo "Failed to update deal.";
        }
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}

function updateDealWithRcData($dealId, $response) {
    try {
        $response = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception("Error decoding response: " . json_last_error_msg());
        }

        $contactPhone = rcTophone($response['data']['rc_number']);
        echo "phone number: ";
	print_r($contactPhone);
        $updateData = [
            'ID' => $dealId,
            'fields' => [
                'UF_CRM_657A8556EA17C' => $response['data']['rc_number'],
                'UF_CRM_1722269383' => $response['data']['fit_up_to'],
                'UF_CRM_1689412695' => $response['data']['registration_date'],
                'UF_CRM_1707034449' => $response['data']['owner_name'],
                'UF_CRM_1722269439' => $response['data']['father_name'],
                'UF_CRM_1722757025397' => $response['data']['present_address'],
                'UF_CRM_1722763762758' => $contactPhone,
                'UF_CRM_1722269536' => $response['data']['vehicle_category'],
                'UF_CRM_1721409291383' => $response['data']['vehicle_chasi_number'],
                'UF_CRM_1721409255084' => $response['data']['vehicle_engine_number'],
                'UF_CRM_6503E06165ABF' => $response['data']['maker_model'],
                'UF_CRM_1722269585' => $response['data']['body_type'],
                'UF_CRM_1722927145947' => $response['data']['fuel_type'],
                'UF_CRM_1722269718' => $response['data']['color'],
                'UF_CRM_1721409885267' => $response['data']['financer'],
                'UF_CRM_1722862270631' => $response['data']['insurance_company'],
                'UF_CRM_1693205894' => $response['data']['insurance_policy_number'],
                'UF_CRM_64E72F2857676' => $response['data']['insurance_upto'],
                'UF_CRM_1722269775' => $response['data']['manufacturing_date'],
                'UF_CRM_1722269847' => $response['data']['registered_at'],
                'UF_CRM_1722269929' => $response['data']['latest_by'],
                'UF_CRM_1689414361007' => $response['data']['cubic_capacity'],
                'UF_CRM_1722270007' => $response['data']['vehicle_gross_weight'],
                'UF_CRM_1722270049' => $response['data']['seat_capacity'],
                'UF_CRM_1722270087' => $response['data']['pucc_number'],
                'UF_CRM_1722270133' => $response['data']['pucc_upto'],
            ],
        ];

        $updateResult = CRest::call('crm.deal.update', $updateData);

        if (isset($updateResult['error'])) {
            throw new Exception("Error updating deal: " . $updateResult['error_description']);
        }

        if ($updateResult['result'] == 1) {
            echo "Deal updated successfully...";
        } else {
            echo "Failed to update deal.";
        }
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>